USE [ProSolutionReports]
GO


SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

/*
--Sample Import View for Use with OneGrade
--For use with ProSolution
--For OneGrade Version 1.23 onwards
*/


CREATE VIEW vOG_StudentUser
AS
SELECT  TOP 100 PERCENT 
		[SD].AcademicYearID,
		[SD].[RefNo] AS StudentRef,
		[SD].[RefNo] AS UserName, --Assuming UserName is the same as RefNo
		'' AS Title,
		LEFT([SD].[FirstForename] + ' ' + ISNULL([SD].[OtherForeNames],''),100) AS ForeNames,
		LEFT([SD].[Surname],100) AS Surname,
		LEFT([SD].[Email],100) AS EmailAddress,
		'' AS Mobile
FROM 
[ProSolution].[dbo].[StudentDetail] SD
WHERE 
SD.[AcademicYearID] IN ('25/26')
AND SD.IsPotentialStudent <> 1

GO

